# = Log4r Logger Test Case
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: log4r_logger_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/logging/impl/log4r_logger'

module Commons
  module Logging
    module Impl

      class Log4rLoggerTest < Test::Unit::TestCase
            
        def setup
          @logger = Log4rLogger.new(self.class.name)
        end
            
            
        def teardown
        end
        
        
        def test_initialize
          # TODO:
        end
        
        
        def test_get_logger
          logger = @logger.get_logger
          assert_not_nil(logger)
          assert_kind_of(Log4r::Logger, logger)
          assert_equal(self.class.name, logger.fullname)
        end
        
        
        def test_trace
          @logger.trace('This is TRACE log.')
          @logger.trace('This is TRACE log.', Exception.new('trace!'))
        end
        
        
        def test_debug
          @logger.debug('This is DEBUG log.')
          @logger.debug('This is DEBUG log.', Exception.new('debug!'))
        end
        

        def test_info
          @logger.info('This is INFO log.')
          @logger.info('This is INFO log.', Exception.new('info!'))
        end
        
        
        def test_warn
          @logger.warn('This is WARN log.')
          @logger.warn('This is WARN log.', Exception.new('warn!'))
        end
        
        
        def test_error
          @logger.error('This is ERROR log.')
          @logger.error('This is ERROR log.', Exception.new('error!'))
        end
        
        
        def test_fatal
          @logger.fatal('This is FATAL log.')
          @logger.fatal('This is FATAL log.', Exception.new('fatal!'))
        end
        
        
        def test_trace?
          assert_true(@logger.trace?)
        end
        
        
        def test_debug?
          assert_true(@logger.debug?)
        end
        
        
        def test_info?
          assert_true(@logger.info?)
        end
        
        
        def test_warn?
          assert_true(@logger.warn?)
        end
        
        
        def test_error?
          assert_true(@logger.error?)
        end
        
        
        def test_fatal?
          assert_true(@logger.fatal?)
        end
      end

    end
  end
end
