# = Stop Watch Test Case
# 
#
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# == Version
# SVN: $Id: stop_watch_test.rb 68 2008-10-05 05:08:21Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/lang/state_error'
require 'commons/lang/time/stop_watch'

module Commons
  module Lang
    module Time

      class StopWatchTest < Test::Unit::TestCase
        SLEEP_TIME = 0.005
        
        
        def setup
          @stop_watch = StopWatch.new
        end
        
        
        def teardown
        end
        
        
        def test_initialize
          # no test.
        end
        
        
        def test_start
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.start
          end
          
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.stop
          end
          
          # 2. Normal
          @stop_watch.reset
          @stop_watch.start
          sleep(SLEEP_TIME)
          @stop_watch.stop
          
          time = @stop_watch.get_time
          assert_true(0 < time && time < 10, "Expected: 0 < time (actual:#{time}) < 10")
        end
        
        
        def test_stop
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.stop
          end
        end
        
        
        def test_reset
          # no test.
        end
        
        
        def test_split
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.split
          end
          
          # 2. Normal
          assert_nothing_raised do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.split
          end
        end
        
        
        def test_unsplit
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.unsplit
          end
          
          # 2. Normal
          assert_nothing_raised do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.split
            @stop_watch.unsplit
          end
        end
        

        def test_suspend
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.suspend
          end
          
          # 2. Normal
          assert_nothing_raised do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.suspend
          end
        end
        
        
        def test_resume
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.resume
          end
          
          # 2. Normal
          assert_nothing_raised do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.suspend
            @stop_watch.resume
          end
        end
        
        
        def test_get_time
          # normal
          @stop_watch.reset
          @stop_watch.start
          sleep(SLEEP_TIME)
          @stop_watch.stop
          time = @stop_watch.get_time
          assert_true(0 < time && time < 10, "Expected: 0 < time (actual:#{time}) < 10")
          
          # suspented
          @stop_watch.reset
          @stop_watch.start
          sleep(SLEEP_TIME)
          @stop_watch.suspend
          time = @stop_watch.get_time
          assert_true(0 < time && time < 10, "Expected: 0 < time (actual:#{time}) < 10")
          
          # not started.
          @stop_watch.reset
          time = @stop_watch.get_time
          assert_equal(0, time, "Expected: 0 < time (actual:#{time}) < 10")
          
          # running
          @stop_watch.reset
          @stop_watch.start
          sleep(SLEEP_TIME)
          time = @stop_watch.get_time
          assert_true(0 < time && time < 10, "Expected: 0 < time (actual:#{time}) < 10")
        end
        
        
        def test_get_split_time
          # 1. Exceptional
          assert_raise(StateError) do
            @stop_watch.reset
            @stop_watch.start
            @stop_watch.stop
            @stop_watch.get_split_time
          end
          
          # 2. Normal
          assert_nothing_raised do
            @stop_watch.reset
            @stop_watch.start
            sleep(SLEEP_TIME)
            @stop_watch.split
            time = @stop_watch.get_split_time
            assert_true(0 < time && time < 10, "Expected: 0 < time (actual:#{time}) < 10")
          end
        end
        
        
        def test_to_s
            @stop_watch.reset
            @stop_watch.start
            sleep(SLEEP_TIME)
            @stop_watch.stop
            p 'Expected (about 5 msec): ' + @stop_watch.to_s
        end
        
        
        def test_to_split_s
            @stop_watch.reset
            @stop_watch.start
            sleep(SLEEP_TIME)
            @stop_watch.split
            p 'Expected (about 5 msec): ' + @stop_watch.to_split_s
        end
      end

    end
  end
end