# = Object Utilities
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: object_utils.rb 74 2008-10-12 02:17:15Z whitestar $
#
# == Since
# File available since Release 0.8.0

module Commons
  module Lang
    
    class ObjectUtils
      
      def initialize
        super()
      end
      
      
      # Append the object id (hex string) to the given string.
      # +buffer+:: string buffer.
      # +object+:: a instance.
      def self.append_identity_to_s(buffer, object)
        if object == nil
          return nil
        end
        if buffer == nil
          buffer = String.new('')
        end
        
        return buffer.concat(
          '#<' + object.class.name + ':0x' + object.__id__.to_s(16) + '>')
      end
      
    end
    
  end
end
