# = Filename Utilities
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: filename_utils.rb 74 2008-10-12 02:17:15Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/lang/system_utils'

module Commons
  module IO
    
    # This class contains utility methods for file name string.
    class FilenameUtils
      def initialize
        super()
      end
      
      
      # Test whether the given path string is absolute path or not.
      def self.absolute?(path)
        return true if path =~ /^(?:\w:)?(?:\/|\\)/
        return true if path[0].chr == '/'
        return false
      end
    end
    
  end
end
