/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This is a collection of types used by the simulation engine */

#ifndef SHAREDTYPES_H_
#define SHAREDTYPES_H_

#if defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
# include <sys/types.h>
# include <netinet/in_systm.h>
#endif
#include <netinet/in.h>
#include <iostream>

namespace spades
{

  typedef int SimTime;
  const SimTime SIMTIME_INVALID = -1;
  inline SimTime simtime_ntoh (SimTime t) { return ntohl (t); }
  inline SimTime simtime_hton (SimTime t) { return htonl (t); }

  /* A lower number means the event will be processed first */
  typedef unsigned EventOrder;
  const EventOrder EO_NORMAL        = 0x01000000;
  const EventOrder EO_SENSE         = 0x05000000;
  const EventOrder EO_TIMENOTIFY    = 0x06000000;
  const EventOrder EO_ACT           = 0x07000000;
  const EventOrder EO_CREATESENSE   = 0x08000000;
  const EventOrder EO_MONITOR       = 0x0e000000;
  const EventOrder EO_ENDSIMULATION = 0x0f000000;

  typedef int AgentID;
  const AgentID AGENTID_INVALID = -1;
  inline AgentID agentid_ntoh (AgentID a) { return ntohl (a); }
  inline AgentID agentid_hton (AgentID a) { return htonl (a); }

  /* This is some old test code. I changed the order of some arguments and I wanted to make sure
     that agents didn't get mistaken for times. I also changed simtime to an unsigned above
     class AgentID
     {
     public:
     AgentID() : id(-1) {}
     //AgentID(int i) : id(i) {}
     explicit AgentID(SimTime t) : id(t) {}
     friend std::ostream& operator<<(std::ostream& o, const AgentID& a) { o << a.id; return o; }
     AgentID& operator++() { id++; return *this; }
     AgentID& operator++(int) { id++; return *this; }
     bool operator<(const AgentID& a) const { return id < a.id; }
     bool operator==(const AgentID& a) const { return id == a.id; }
     private:
     int id;
     };
     const AgentID AGENTID_INVALID = AgentID();
     inline AgentID agentid_ntoh (AgentID a) { return a; }
     inline AgentID agentid_hton (AgentID a) { return a; }
  */
  
  typedef int ServerID;
  const int SERVERID_INVALID = -1;
  inline ServerID serverid_ntoh (ServerID s) { return ntohl (s); }
  inline ServerID serverid_hton (ServerID s) { return htonl (s); }

  typedef int MonitorID;
  const int MONITORID_INVALID = -1;
  inline MonitorID monitorid_ntoh (MonitorID s) { return ntohl (s); }
  inline MonitorID monitorid_hton (MonitorID s) { return htonl (s); }

  enum AgentStatus
    {
      AS_Initializing,
      AS_Thinking,
      AS_ThinkingUntimed,
      AS_Waiting,
      AS_Migrating
    };
  inline bool isThinkingStatus(AgentStatus s) 
  { return s == AS_Thinking || s == AS_ThinkingUntimed; }
  std::ostream& operator<<(std::ostream& o, const AgentStatus& s);

  enum AgentLostReason {
    ALR_None,
    ALR_ProcessVanished,
    ALR_BadFD,
    ALR_InitError,
    ALR_WorldModel,
    ALR_CommServerDisconnect,
    ALR_AgentRequest,
    ALR_Internal,
    ALR_ThinkTooLongWallClock,
    ALR_ThinkTooLongSim
  };
    
  std::ostream & operator << (std::ostream & o, const AgentLostReason& r);

  enum ThinkingType  {
    TT_Invalid,
    TT_Not,
    TT_Regular,
    TT_Untimed
  };
  inline bool startsThinkingCycle(const ThinkingType& t)
  { return t == TT_Regular || t == TT_Untimed; }
    
  std::ostream& operator<<(std::ostream& o, const ThinkingType& t);

  AgentStatus thinkingTypeToAgentStatus(ThinkingType t);
  ThinkingType agentStatusToThinkingType(AgentStatus s);

  extern const char* XML_NAMESPACE;
  
} //spades namespace

#endif
