/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file provides a few constants and types to be used by the SPADES IPC messaging
   system. Things are here instead of my normal parameter scheme because the
   library which overrides system calls to do the notification will not be able
   to access that, so we have to hardwire everything */

#ifndef MESSAGE_TYPES_H_
#define MESSAGE_TYPES_H_

#include "spades-config.h"
#if SPADES_TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if SPADES_HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#if defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
#  include <sys/msgbuf.h>
#else
#  include <sys/msg.h>
#endif
#include <unistd.h>
#include <stdio.h>

namespace spades
{

  namespace Message
  {
    //We incorporate the UID so that different users on the same machine can run in parallel
    //returns a pointer to a static buffer
    inline const char* getKeyFN()
    {
      static char key_fn[128];
      sprintf(key_fn, "/tmp/SPADES_IPC.%d", getuid());
      return key_fn;
    }
    
    const char PROJECT_CHAR = 'Z';

    enum MsgType {
      MT_None = 0,
      MT_Fork,
      MT_ForkWithUniqID
    };

    struct MsgUniqueID
    {
      MsgUniqueID()
	: tv_send(), val(0) {}
      MsgUniqueID(const struct timeval& tv_send, int val)
	: tv_send(tv_send), val(val) {}
      struct timeval tv_send;
      // This may not acutally be a unique id,
      // but it can be used to prevent some confusion about who is sending fd
      int val;
    };

    // It is important that the message type is first; the IPC stuff requires this
    struct MsgForkWithUniqID
    {
      long mtype; // message type
      int pid_parent;
      int pid_child;
      MsgUniqueID uniqid;
    };
    const int MSG_FORK_TEXT_SIZE = sizeof(MsgForkWithUniqID) - sizeof(long);

    inline const char* getSocketPath()
    {
      static char path[128];
      sprintf(path, "/tmp/SPADES_socket.%d", getuid());
      return path;
    }
    
    
  } //namespace Message

} //namespace spades


#endif
