/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class collects write requests to amortize the cost of the write
   to the actual file descriptor */

#ifndef WRITE_BUFF_COLLECTOR_H_
#define WRITE_BUFF_COLLECTOR_H_

#include "WriteBuffFD.hpp"

namespace spades
{

  class WriteBuffCollectorFD 
    : public WriteBuffFD
  {
  public:
    WriteBuffCollectorFD(int packet_size, int new_fd = -1);
    virtual ~WriteBuffCollectorFD();

    /* These functions override WriteBuffFD functions */
    //returns false onlu on unrecoverable errors
    //This may buffer the message
    bool write (const char* buf, int buflen);

    virtual bool close();

    /* These are brand new functions */
    /* returns false on unrecoverable errors */
    bool flush();
  
    friend std::ostream& operator<<(std::ostream& o, const WriteBuffCollectorFD& f)
    { o << "WriteBuffCollectorFD(fd="<<f.getFD()<<",ps="<<f.packet_size<<")"; return o; }

    //returns true iff all flushes were successful
    static bool flushAllCollected();

  protected:
    //also defined in WriteBuffFD
    virtual void setFD(int new_fd);
    
  private:
    int packet_size;

    char* write_buffer;
    int write_buffer_len; //amount of actual data in the write buffer

    /* pfr 5/22/2002: I used to have this representing only the fd that needed to be
       flushed at any point. However, that introduced some inefficiency because
       we kept having to insert and delete things from the set
       Instead, this now represents all currently active WriteBuffCollFD
       This means that on a flushAllCollected, even those fd that don't have data
       are flushed */
    typedef std::set<WriteBuffCollectorFD*> CollBuffSet;
    static CollBuffSet coll_buff_set;

    // these function should not be used! only for error catching. They are not defined.
    WriteBuffCollectorFD(const WriteBuffCollectorFD& s);
    const WriteBuffCollectorFD& operator=(const WriteBuffCollectorFD& s);

  };


} //spades namespace

#endif
