/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class provides an abstraction over a Unix domain socket.
   It is NOT intended as a general purpose class, but it hides
   some low level system hacking
   I used the code from the perfctr perfex example code (http://perfctr.sf.net
   for inspiration and a little bit of verbatim copying */

/* This file is used in agent_intercept also is a "detached" compile mode
   so you need to be very careful if you add any dependencies for this file!
   See agent_intercept/DetachedUnixSocket for what this means */

#ifndef UNIXSOCKET_H_
#define UNIXSOCKET_H_

#include "spades-config.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <stddef.h>	/* for offsetof() */
#include <string>
#include "message_types.hpp"

namespace spades
{

  // This only supports the binding of a socket, and then connectionless
  // operation
  
  class UnixSocket
  {
  public:
    UnixSocket();
    ~UnixSocket();

    bool create();
    
    bool close();

    int getSocketFD() const { return fd; }
     
    // creates the name for this unix domain socket
    bool bindToFile(const char* path);

    bool setNoBlock(bool val);
    
    class FDMessageContent
    {
    public:
      FDMessageContent()
	: fd(-1), content(0), uniqid() {}
      FDMessageContent(int fd, int content, const Message::MsgUniqueID& uniqid)
	: fd(fd), content(content), uniqid(uniqid) {}
      
      int fd;
      int content;
      Message::MsgUniqueID uniqid;
    };

    // The main thing I will use this for is to send file descriptors
    // around. These next two method do this.

    // returns whether a message was received.
    // if there is an error on the socket, true will be returned
    // and fd will be set to -1
    bool receiveFD(FDMessageContent* pmsg);

    // sends a file descriptor on the socket
    // every msg must have content
    // The this socket here represents the sender, not the receiver
    bool sendFDTo(const char* sockname, const FDMessageContent& msg);

    //testing code
    // need to start two processes, one that does testReceive,
    // one that does testSend
    static void testReceive();
    static void testSend();
    
  private:
    // from perfctr/examples/perfex/perfex.c
    struct cmsg_fd {
      struct cmsghdr hdr;
      int fd;
      /* 64-bit machines pad here, which causes problems since
	 the kernel derives the number of fds from the size.
	 The CMSG_FD_TRUE_SIZE macro gives the true payload size. */
    };
    static const unsigned CMSG_FD_TRUE_SIZE = (offsetof(struct cmsg_fd, fd) + sizeof(int));
    static const unsigned CMSG_FD_PADDED_SIZE = sizeof(struct cmsg_fd);

    int fd;
    std::string bound_name;
  };
  
  

} //spades namespace


#endif
