/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class provides read and write access to a file of think times */

#ifndef THINK_TIME_FILE_H_
#define THINK_TIME_FILE_H_

#include <fstream>
#include "sharedtypes.hpp"

namespace spades {

  class ThinkTimeFile
  {
  public:
    ThinkTimeFile();
    ~ThinkTimeFile();

    bool openIn(const char* fn);
    bool openOut(const char* fn, int bytes_per = DEFAULT_BYTES_PER);

    void close() { file.close(); }
    bool isGood() { return file.good(); }

    bool writeThinkTime(SimTime t);
    SimTime readThinkTime();
    
  private:
    std::fstream file;
    int bytes_per; // the number of bytes per think time

    static const int DEFAULT_BYTES_PER;
  };
  
  
  
} //namespace spades

#endif
