/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class will represent important information about a particular system */

#ifndef SYSTEM_INFORMATION_H_
#define SYSTEM_INFORMATION_H_

#include <iostream>
#include <vector>

namespace spades
{

  class SystemInformation
  {
  public:
    SystemInformation();
    ~SystemInformation();

    bool readForThisSystem();

    // now the main access methods
    float getBogoMIPS() const { return bogomips; }
    unsigned getNumCPU() const { return num_cpu; }
    const std::string& getHostName() const { return host_name; } 
    const std::string& getDomainName() const { return domain_name; } 
    const std::string& getShortHostName() const { return short_host_name; } 
    
    friend std::ostream& operator<<(std::ostream& os, const SystemInformation& si);
    
    // returns an object with information about this system
    static SystemInformation* thisSystem();

  private:
    bool readCPUInfo();
    bool readHostName();
    bool setBogoMIPS(const std::vector<float>& v);
    
    unsigned num_cpu;
    float bogomips;
    std::string host_name;
    std::string domain_name;
    std::string short_host_name;
    
    static SystemInformation* this_system;
  };
  
  
} //spades namespace

#endif
