/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* these classes provide a queue of messages received from an agent */

#ifndef STRING_REPLACER_H_
#define STRING_REPLACER_H_

#include <string>
#include <vector>

namespace spades
{
  /* You can add in an ordered set of replacements (like '%D' -> '12')
     You can redefine a replacement and the ordering stays the same
     performReplacements keeps iterating over the list of replacements
     until none of them match */
  class StringReplacer
  {
  public:
    StringReplacer() {}
    ~StringReplacer() {}

    void clear();

    //returns true if the find string already existed
    bool addReplacement(const std::string& find, const std::string& repl);

    std::string performReplacements(const char* str) const;
    std::string performReplacements(const std::string& str) const
    { return performReplacements(str.c_str()); }
    
  private:
    // an individual first gets replaced by second
    typedef std::pair<std::string, std::string> ReplEntry;
    // a storage for a bunch of replacements
    typedef std::vector<ReplEntry> ReplStorage;
    
    ReplStorage replacements;

    // the maximum number of iterations through the replacement list
    // Basically, maximum depth of nested replacements
    static const int MAX_REPLACE_ITER = 50;
  };
  
  
} //spades namespace

#endif
