/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef SHAREDPARAM_H_
#define SHAREDPARAM_H_

#include "ParamReader.hpp"

namespace spades
{

  class SharedParam
    : public ParamReader
  {
  public:

    SharedParam ();
    virtual ~ SharedParam ();

    static SharedParam* instance() { return s_instance; }

  private:
    static SharedParam* s_instance;
    
  protected:
    //virtual void writeConfig ( ostream& o ) = 0;

    virtual void addAll2Maps ();
    virtual void setDefaultValues ();
    virtual void postReadProcessing ();

  public:

    bool getVersion() const { return version; }
    bool getHelp() const { return help; }

    std::string getLogfileDir () const { return logfile_dir; }
    bool getCreateLogfileDir() const { return create_logfile_dir; }
    std::string getActionLogFN () const { return action_log_fn; }
    int getActionLogLevel () const { return action_log_level; }
    std::vector<std::string> getLogChannels() const { return log_channels; }

    int getEnginePort() const { return engine_port; }

    bool getUseRandomness() const { return use_randomness; }
    int  getRandomSeed() const { return random_seed; }
    bool getPrintRandomSeedToStdout() const { return print_random_seed_to_stdout; }
    
    int getInternalTcpPacketSize() const { return internal_tcp_packet_size; }

    int getSecsForSocketShutdown() const { return secs_for_socket_shutdown; }

    std::string getAgentDBFN() const { return agent_db_fn; }
    int getMaxATRefDepth() const { return max_at_ref_depth; }

    int getStatusUpdateInterval() const { return status_update_interval; }  

    bool getTraceOnError() const { return trace_on_error; }

    bool getCreateAgentLogfiles() const { return create_agent_logfiles; }
    std::string getAgentStdoutLogFPat() const { return agent_stdout_log_fpat; }
    std::string getAgentStderrLogFPat() const { return agent_stderr_log_fpat; }
    
    double getSecsForAgentShutdown() const { return secs_for_agent_shutdown; }

    double getMaxSecsForAgentThink() const { return max_secs_for_agent_think; }
    int getMaxSimtimeForAgentThink() const { return max_simtime_for_agent_think; }

    int getAgentPacketSize() const { return agent_packet_size; }
  
    int getDefaultAgentInputFD() const { return default_agent_input_fd; }
    int getDefaultAgentOutputFD() const { return default_agent_output_fd; }

    int getMaxUnnaturalLostAgents() const { return max_unnatural_lost_agents; }

    double getLoadSendInterval() const { return load_send_interval; }  

    bool getSendAgentThinkTimes() const { return send_agent_think_times; }

    bool getSendAgentSendTime() const { return send_agent_send_time; }
    bool getSendAgentArriveTime() const { return send_agent_arrive_time; }
    
    std::string getDefaultProcessTimer() const { return default_process_timer; }
    
    bool getRecordThinkTimes() const { return record_think_times; }
    std::string getThinkTimesFilePattern() const { return think_times_file_pattern; }
    int getReplayThinkBufferSize() const { return replay_think_buffer_size; }
    
    std::string getAgentInterceptLibrary() const { return agent_intercept_library; }

    bool getEnableIPCMessageReception() const { return enable_ipc_message_reception; }
    bool getIPCForceRemove() const { return ipc_force_remove; }
    
    bool getAgentCheckUseRandomness() const { return agent_check_use_randomness; }
    bool getAgentCheckThresholdSec() const { return agent_check_threshold_sec; }
    double getAgentCheckDistMin() const { return agent_check_dist_min; }
    double getAgentCheckDistMax() const { return agent_check_dist_max; }
    double getAgentCheckDistMode() const { return agent_check_dist_mode; }

    double getPerfctrMaxWaitForFD() const { return perfctr_max_wait_for_fd; }

    bool getWriteParameters() const { return write_parameters; }
    const std::string& getParametersOutFN() const { return parameters_out_fn; }
    
  protected:

    bool version;

    bool help;
    
    std::string logfile_dir;
    bool create_logfile_dir;
    std::string action_log_fn;
    int action_log_level;
    std::vector<std::string> log_channels;
    
    int engine_port;

    bool use_randomness;
    int  random_seed;
    bool print_random_seed_to_stdout;
    
    int internal_tcp_packet_size;

    int secs_for_socket_shutdown;

    std::string agent_db_fn;
    int max_at_ref_depth;
    
    int status_update_interval;

    bool trace_on_error;

    bool create_agent_logfiles;
    std::string agent_stdout_log_fpat;
    std::string agent_stderr_log_fpat;    

    double secs_for_agent_shutdown;

    double max_secs_for_agent_think;
    int max_simtime_for_agent_think;
    
    int agent_packet_size;

    int default_agent_input_fd;
    int default_agent_output_fd;
    
    int max_unnatural_lost_agents;

    double load_send_interval;

    bool send_agent_think_times;

    bool send_agent_send_time;
    bool send_agent_arrive_time;

    std::string default_process_timer;

    bool record_think_times;
    std::string think_times_file_pattern;
    int replay_think_buffer_size;

    std::string agent_intercept_library;

    bool enable_ipc_message_reception;
    bool ipc_force_remove;
    
    bool agent_check_use_randomness;
    bool agent_check_threshold_sec;
    double agent_check_dist_min;
    double agent_check_dist_max;
    double agent_check_dist_mode;

    double perfctr_max_wait_for_fd;

    bool write_parameters;
    std::string parameters_out_fn;
    
  };

} //spades namespace

#endif
