/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef SHARED_LOGGER_CHANNELS_H_
#define SHARED_LOGGER_CHANNELS_H_

#include "Logger.hpp"

namespace spades
{

#define SLC spades::SharedLoggerChannels::instance()
  
  class SharedLoggerChannels
  {
  public:
    //This is a Singleton, you should only construct via instance()
    ~SharedLoggerChannels ();

    // a parent for all these other classed
    Logger::ChannelID shared() const { return cid_shared;}

    Logger::ChannelID timer() const { return cid_timer; }
    Logger::ChannelID agentio() const { return cid_agentio;}
    Logger::ChannelID agentmanage() const { return cid_agentmanage;}
    Logger::ChannelID agentint() const { return cid_agentint;}
    Logger::ChannelID atdb() const { return cid_atdb;}
    Logger::ChannelID network() const { return cid_network;}
    Logger::ChannelID perfctr() const { return cid_perfctr;}
    Logger::ChannelID ipc() const { return cid_ipc;}
    Logger::ChannelID procman() const { return cid_procman;}
    Logger::ChannelID sys() const { return cid_sys;}
    
  private:
    // a parent for all these other classed
    Logger::ChannelID cid_shared;

    Logger::ChannelID cid_timer;
    Logger::ChannelID cid_agentio;
    Logger::ChannelID cid_agentmanage;
    Logger::ChannelID cid_agentint;
    Logger::ChannelID cid_atdb;
    Logger::ChannelID cid_network;
    Logger::ChannelID cid_perfctr;
    Logger::ChannelID cid_ipc;
    Logger::ChannelID cid_procman;
    Logger::ChannelID cid_sys;
    
  public:
    static SharedLoggerChannels* instance();
  
  private:
    /* this is private so that the instance method is the only one that can allocate */
    SharedLoggerChannels ();
  
    static SharedLoggerChannels* s_instance;

  };

}

#endif
