/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file defines the base sense type */

#ifndef SENSEEVENT_H_
#define SENSEEVENT_H_

#include "FixedAgentEvent.hpp"
#include "SimEngine.hpp"
#include "DataArray.hpp"

//#define PRINT_DATA

namespace spades
{

  class SenseEvent
    : public FixedAgentEvent
  {
  public:
    SenseEvent (ThinkingType think, SimTime t_send, SimTime t_arrive, AgentID a,
		EventOrder o = EO_SENSE)
      : FixedAgentEvent (t_arrive, a, o), data(), thinking(think), send_time(t_send)
    {}
    virtual ~SenseEvent () { }

    virtual void print (std::ostream & o) const
#ifdef PRINT_DATA
    { std::string s(data.getData(), data.getSize());
    o << "SenseEvent(t:" << getTime () << ", a:" << getAgent() << ", th: " << thinking << ", d:" << s << ")"; }
#else
    { o << "SenseEvent(t:" << getTime () << ", a:" << getAgent() << ", th:" << thinking << ")"; }
#endif

    virtual SenseEvent* clone() { return new SenseEvent(*this); }
    
    bool realizeAgentEventSimEngine(SimEngine* pSE, AgentInfo* painfo);

    SimTime getSendTime () const { return send_time; }

    void setData(const DataArray& d) { data = d; }
    const DataArray& getData () const { return data; }

    ThinkingType getThinking() const { return thinking; }
    void setThinking(ThinkingType t) { thinking = t; }

  protected:
    DataArray data;

  private:
    //Thinking sensations are ones to which the agent can respond
    ThinkingType thinking;

    //The time stored in the Event base class is the arrive time
    SimTime send_time;
  
  };

} //spades namespace



#endif
