/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class provides my interface to the PerfCtr facilities */
/* It should only be compiled if PerfCtr support is enabled */

#ifndef PERFCTRFD_H_
#define PERFCTRFD_H_

#include "spades-config.h"
#if !SPADES_HAVE_PERFCTR
#error PerfCtr.hpp should only be compilied if SPADES_HAVE_PERFCTR is true
#endif
extern "C" {
#include <libperfctr.h>
}
#include "message_types.hpp"

namespace spades
{

  // This class encapsulates a file descriptor into a perfctr read area
  class PerfCtrFD
  {
  public:
    PerfCtrFD(int fd = -1);
    virtual ~PerfCtrFD();

    // gets the fd for our own perfctr
    bool openSelf();

    // close this descriptor
    virtual bool close();
    
    // Does our "normal" control procedure getting retired instructions in pmc[0]
    bool performStandardControl();

    // sends this file descriptor to the unix socket with the given name
    bool sendFDTo(const char* dest_sock_name, const Message::MsgUniqueID& uniqid);

    static bool getControlInfo(struct vperfctr* pctr,
			       struct vperfctr_control* pcontrol);
    // the file descriptor should be a perfctr one
    static bool getControlInfo(int fd,
			       struct vperfctr_control* pcontrol);

    // opens self, does standard control, sends the fd to a socket, then closes
    static bool openControlSend(const char* socket_path, const Message::MsgUniqueID& uniqid);

    // returns whether a perfctr timer has been set up on us
    static bool isPerfCtrActiveOnSelf();

  protected:
    int getFD() const { return fd; }
      
  private:
    PerfCtrFD(const PerfCtrFD&); // not acutally defined; should never be used
    const PerfCtrFD& operator=(const PerfCtrFD&); // not acutally defined; should never be used
    
    int fd;

    static bool getControlInfoHelper(const struct perfctr_info* info,
				     struct vperfctr_control* pcontrol);

  };
  
  

} //spades namespace


#endif
