/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class is an event to send information to the monitors */

#ifndef MONITOR_SEND_EVENT_H_
#define MONITOR_SEND_EVENT_H_

#include <iostream>
#include "Event.hpp"

namespace spades
{

  class MonitorSendEvent
    : public Event
  {
  public:
    MonitorSendEvent (SimTime t) : Event(t, EO_MONITOR) {}
    ~MonitorSendEvent () {}

    int getSecondaryOrder() const { return 0; }
    
    void print (std::ostream & o) const;

  protected:
    bool realizeEventSimEngine(SimEngine* pSE);
    

  private:
  };


} //spades namespace


#endif
