/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef MONITOR_PROXY_H_
#define MONITOR_PROXY_H_

#include <sys/types.h>
#include <fstream>
#include "sharedtypes.hpp"
#include "FDSet.hpp"
#include "DataArray.hpp"
#include "TCPSocket.hpp"

namespace spades
{

  class SimEngine;
  
  /*****************************************************************/
  class MonitorProxyCallbacks
  {
  public:
    MonitorProxyCallbacks() {}
    virtual ~MonitorProxyCallbacks() {}

    virtual SimEngine* getSimEngine() = 0;

  };
  /*****************************************************************/

  class MonitorProxy
  {
  public:
    MonitorProxy(MonitorID m, MonitorProxyCallbacks* p)
      : monitorID(m), pCallbacks(p), disconnect_request(false) {}
    virtual ~MonitorProxy() {}

    virtual bool disconnect() = 0;
    virtual bool send(const DataArray& d) = 0;

    //returns the number of fd handled with this Monitor
    virtual int processReadSet(const fd_set* read_set) = 0;

    MonitorID getMonitorID() const { return monitorID; }

    bool getDisconnectRequest() const { return disconnect_request; }
    
  protected:
    MonitorID monitorID;
    MonitorProxyCallbacks* pCallbacks;
    bool disconnect_request;
    
  private:
  };

  /*****************************************************************/

  class ExternalMonitorProxy
    : public MonitorProxy
  {
  public:
    ExternalMonitorProxy(MonitorID m,
			 MonitorProxyCallbacks* p,
			 TCPSocket *psocket);
    ~ExternalMonitorProxy();

    bool disconnect();
    bool send(const DataArray& d);

    //returns the number of fd handled
    int processReadSet(const fd_set* read_set);

  private:

    bool parseBuf(int len);
    
    TCPSocket* psocket;

    char* recv_buf;
    unsigned recv_buf_size;

    static const int DEFAULT_BUFFER_SIZE;

  };
  
  /*****************************************************************/

  class LogfileMonitorProxy
    : public MonitorProxy
  {
  public:
    LogfileMonitorProxy(MonitorID m,
			MonitorProxyCallbacks* p,
			const char* fn);
    ~LogfileMonitorProxy();

    bool disconnect();
    bool send(const DataArray& d);

    //returns the number of fd handled
    int processReadSet(const fd_set* read_set);

  private:
    std::ofstream logfile;

  };
  

  

} //namespace spades
 
#endif
