/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class maintains information about the monitors attached to the simulation engine,
   and handles all messaging */

#ifndef MONITOR_MANAGER_H_
#define MONITOR_MANAGER_H_

#include <map>
#include "TCPSocket.hpp"
#include "MonitorProxy.hpp"

namespace spades 
{

  class SimEngine;
  class Communication;
  
  class MonitorManager
    : public MonitorProxyCallbacks
  {
  public:
    MonitorManager(SimEngine* pSE);
    ~MonitorManager();

    bool initialize();
    
    //returns the number of fd handled
    int processReadSet(const fd_set* read_set);

    void sendMonitorInfo(SimTime t);

    void sendExtraMonitorInfo(const DataArray& d) { sendToMonitors(d); }
    
    //this implements the MonitorProxyCallbacks interface
    void disconnectMonitor(MonitorID m);
    SimEngine* getSimEngine() { return pSimEngine; }

  private:
    typedef std::map<MonitorID, MonitorProxy*> MonitorMap;

    void disconnectMonitor(MonitorMap::iterator iter);

    MonitorID acceptNewMonitor();

    void sendToMonitors(const DataArray& d);
    
    //returns false on any error
    bool addMonitorProxy(MonitorProxy* mon);
    
    SimEngine* pSimEngine;
    TCPSocket sock_connect;

    MonitorID nextid;
    
    MonitorMap monitor_map;
  };
  
  
  
}


#endif
