/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file contain a class which helps reads the data off a socket and break it into
   chunks for messages, which can then be processed.
   In order to do this, you inherit from this virtual base class
   It is recommended that you make this a long lived object attached to a socket.
   The class does exponentially increasing allocations of buffer space
   If you keep creating and destroying the objects, you lose the knowledge about how
   big the messages have been */

#ifndef MESSAGE_PARSER_H_
#define MESSAGE_PARSER_H_

#include "sharedtypes.hpp"
#include "TCPSocket.hpp"

namespace spades
{

  class MessageParser
  {
  public:
    MessageParser (TCPSocket* ps);
    virtual ~MessageParser ();

    //returns the number of messages processed
    //returns -1 if the socket is closed
    int processMessages ();

    enum MessageError
      {
	ME_None,
	ME_LastMessage,
	ME_NotEnoughData,
	ME_BadFormat
      };

  protected:
    virtual MessageParser::MessageError processBuffer (char *buffer, int datalen, int *pbytes_consumed) = 0;

    void changeSocket(TCPSocket* p) { psocket = p; }
    
  private:
    TCPSocket* psocket; //this is the socket from which to read data

    char* buffer;
    short buffer_size;

    static const int DEFAULT_BUFFER_SIZE;

    //makes the buffer larger
    void expandBuffer();
  };

  std::ostream& operator<<(std::ostream& o, const MessageParser::MessageError& e);


} //spades namespace


#endif
