/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef MACHINELOAD_H_
#define MACHINELOAD_H_

#include <iostream>

namespace spades
{

  class MachineLoad; //defined in this file
  class CSEMessage_MachineLoad; //defined in CSEMessage
  
  // The class represents the knowledge of the load of a machine that SPADES wants to know about
  class LoadInfo
  {
  public:
    LoadInfo() : percentage_used(-1.0), ready_processes(-1.0) {}
    ~LoadInfo() {}

    float getPercentageUsed() const { return percentage_used; }
    float getAvgReadyProcesses() const { return ready_processes; }

    friend std::ostream & operator << (std::ostream & o, const LoadInfo & l)
    { o << "Load(%: " << l.percentage_used << ", #: " << l.ready_processes << ")"; return o; }
    
  protected:
    friend class CSEMessage_MachineLoad;
    friend class MachineLoad;
    
    //The percentage of time that the CPU is in use
    float percentage_used;

    //avg number of ready processes
    float ready_processes;    
  };
  
  
  // This class knows how to read a machine load from the kernel
  class MachineLoad
  {
  public:
    MachineLoad();
    ~MachineLoad();

    bool readLoad();
    const LoadInfo& getLoadInfo();

  protected:
    unsigned int last_read_used_jiffies;
    unsigned int last_read_idle_jiffies;

    unsigned int times_read;

    LoadInfo load_info;

  };

} //spades namespace

#endif
