/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* this class implements the functions to do a length prefixed write to a Writable
   class */
#ifndef LENGTH_PREFIX_WRITER_H_
#define LENGTH_PREFIX_WRITER_H_

#include "Writable.hpp"

namespace spades 
{

  class LengthPrefixedWriter
  {
  public:
    LengthPrefixedWriter(spades::Writable* w = NULL)
      : writable(w), partial_length_remaining(0), error(false) {}
    ~LengthPrefixedWriter() { checkPartialFinished(); }

    spades::Writable* getWritable() const { return writable; }
    void setWritable(spades::Writable* w);

    //returns true if there has been an unrecoverable error
    bool getError() const { return error; }
    
    // must be a complete utterance
    bool send(const char *msg, int len);
    //expects a null-terminated string
    bool send(const char *msg);

    //these can be partial messages;
    // You have to send the length of all partial messages you are going to send,
    // then put on all those bytes. 
    bool sendPartialLength(unsigned len);
    bool sendPartial(const char*, unsigned len);
    bool sendPartial(const char* msg);

    
  private:
    void checkPartialFinished();
    
    spades::Writable* writable;

    int partial_length_remaining;

    bool error;
  };
  
  
} //spades namespace
 

#endif
