/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef INTEGRATED_AGENT_H_
#define INTEGRATED_AGENT_H_

#include "sharedtypes.hpp"

namespace spades 
{

  class IntegratedAgentActions;
  
  // This is a virtual base class that agent writers implement for their agents
  // to be loaded as a dynamic library

  class IntegratedAgent
  {
  public:
    IntegratedAgent() {}
    virtual ~IntegratedAgent() {}

    void setActionCallbacks(IntegratedAgentActions* p) { pactions = p; }
    // The pActions member WILL be set before this is called
    // return false on error
    virtual bool initialize(const std::string init_args) = 0;
    
    virtual void receiveTimeNotify(ThinkingType th, SimTime t) = 0;
    virtual void receiveSense(ThinkingType th, SimTime send_time, SimTime arrive_time,
                              const char* data, unsigned length) = 0;
    virtual void receiveMigrationRequest() = 0;
    virtual void receiveExit() = 0;
    virtual void receiveInitData(const char* data, unsigned length) = 0;
    virtual void receiveError(const std::string& errmsg) = 0;
    virtual void receiveThinkTime(SimTime t, bool intermediate) = 0;

  protected:
    IntegratedAgentActions* getActions() { return pactions; }    
    const IntegratedAgentActions* getActions() const { return pactions; }    

  private:
    IntegratedAgentActions* pactions;
  };

  //This is the class the IntegratedAgent object can use to make callbacks
  // to actually perform the various actions
  class IntegratedAgentActions
  {
  public:
    IntegratedAgentActions() {}
    virtual ~IntegratedAgentActions() {}

    virtual void act(const std::string& d) = 0;
    virtual void requestTimeNotify(SimTime t) = 0;
    virtual void doneThinking() = 0;
    virtual void exit() = 0;
    virtual void initDone() = 0;
    virtual void migrationData(const std::string& d) = 0;
    virtual void requestCurrentThinkTime() = 0;
  };
  
} //spades namespace

typedef spades::IntegratedAgent* CreateAgentEntryPoint(void);

#endif
