/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This event should be a base type for all events which should get put into the individual agent
   queues.
   These are events whose effects are fixed and only affect a particular agent, NOT the world model
   itself.
*/
  
#ifndef FIXEDAGENTEVENT_H_
#define FIXEDAGENTEVENT_H_

#include "Event.hpp"

namespace spades
{

  class SimEngine;
  class AgentInfo;
  
  class FixedAgentEvent
    : public Event
  {
  public:
    FixedAgentEvent (SimTime t, AgentID a, EventOrder o = EO_NORMAL)
      : Event (t, o), agent(a) {}
    virtual ~FixedAgentEvent () {}

    virtual void print (std::ostream & o) const
    { o << "FixedAgentEvent(" << getTime () << ") for " << agent; }

    virtual int getSecondaryOrder() const { return static_cast<int>(agent); }

    //this function actually realizes the event. In general, you should not override this,
    // but override one of the protected methods realizeEventSimEngine or realizeEventWorldModel
    // returns true if the pointer was requeued anywhere (otherwise, it could be deleted)
    virtual bool realizeEvent(SimEngine* pSE);

    // indicates that we are a FixedAgentEvent
    bool isFixedAgentEvent() { return true; }
    
    AgentID getAgent () const { return agent; }
    // do NOT call this method for anything that has been enqueed. Bad things can result
    void setAgent (AgentID a) { agent = a; }
  
    //subclasses do not override this.
    // they should override realizeAgentEventSimEngine below
    //returns true if the event was requeed elsewhere
    bool realizeAgentEvent(SimEngine* pSE, AgentInfo* painfo);

  protected:
    /* FixedAgentEvents have to be queued on agents first
       , then realized through realizeAgentEvent (which then calls realizeAgentEventSimEngine)
       so this shoudl never be called */
    bool realizeEventSimEngine(SimEngine* pSE);

    virtual bool realizeAgentEventSimEngine(SimEngine* pSE, AgentInfo* painfo) { return false; }
    
  private:
    AgentID agent;
  
  };

} //spades namespace



#endif
