/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 Part of this file was originally taken from the SoccerServer and
 modified. The SoccerServer is also released under the GNU Lesser
 General Public License.

 Copyright (C) 1996-2000 Electrotechnical Laboratory. 
 Itsuki Noda, Yasuo Kuniyoshi and Hitoshi Matsubara.
 Copyright (C) 2000, 2001 RoboCup Soccer Server Maintainance Group.
 Patrick Riley, Tom Howard, Daniel Polani, Itsuki Noda,
 Mikhail Prokopenko, Jan Wendler 

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/


#ifndef FILE_UTILS_H_
#define FILE_UTILS_H_

#include <string>
#include <iostream>

namespace spades
{

  // This class only contains static methods
  // These are useful for manipulating files, both opened and unopened
  class FileUtils
  {
  public:

    static std::string tildeExpand (const std::string & path_name);

    /* the starting_file_path is assumed to be the path to a file,
       so the dirname of it is taken unless it ends with /
       the result is an absolute path name, assuming the cwd is the dir of
       starting_file_path (if that is relative, it's resolved relative
       to the real cwd).
       Note this does NOT require the path exists (though starting_file_path
       must). See also resolvePathGivenStartingFile */
    static std::string createAbsPathGivenStartingFile( const char* starting_file_path,
                                                       const char* path);

    /* the starting_file_path is assumed to be the path to a file,
       so the dirname of it is taken unless it ends with /
       the return is the canonical file path of path, assuming you start from
       the directory of starting_file_path
       Note that this requires that the files exists! */  
    static std::string resolvePathGivenStartingFile( const char* starting_file_path,
                                                     const char* path);

    /* relative paths are resolves relative to the current working directory */
    static bool doesFileExist(const char* path);

    /* Ensures the directory exists and is a directory. Tries to create
       if try_to_create is true (but will only create one level
       (like a mkdir, not a mkdir -p)
       Returns false if it could not be created */
    static bool insureDirExists(const char* dirname, bool try_to_create);
    
    // returns false if eof
    static bool skip_white_space(std::istream& infile) ;
    // returns false if eof or eol
    static bool skip_white_space_on_line(std::istream& infile) ;
    //returns false if eof
    static bool skip_line(std::istream& infile);
    //returns false if eof or other error
    static bool skip_to_character(std::istream& infile, char c);

  private:
    FileUtils(); // one should never make an instance of this class
    
  };
 
} //spades namespace

#endif
