/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* an abstract base class to provide reuse of functionality for reading from a file
   The file reader assumes a line based reading of the scheme
   # is a comment character
   The first non comment, non space line should be:
   version: %f
   such as
   version: 1.2
   When asked to read the file, a maximum version will be given, If the version is too high
   an error will be printed. On every line given to processLine, the current version will
   be accessible
*/

#ifndef FILE_READER_H_
#define FILE_READER_H_

#include <iostream>

namespace spades
{

  class FileReader
  {
  public:
    FileReader() {}
    virtual ~FileReader() {}

    void readFile (const char* path, float max_version) { readFile(path, max_version, 0);  /* recursion depth 0 */}

  protected:
    static const int MaxRecFileDepth;

    //This is the function that children classes have to define
    // The fileid is to be printed in front of error messages and stuff
    // The path is the full path of the file
    // the version is the version of this file
    virtual bool processLine(std::istream& line,
			     const char* fileid,
			     const char* path,
			     float version) = 0;

  private:

    //we allow recursive file reading; This variant is private to insure that the first call
    //is correct.
    void readFile (const char *path, float max_version, int depth);
  };

} //spades namespace


#endif
