/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class stores a set of file descriptors both as an STL set and as a
   fd_set (as used by select). We need to do both so that we can provide a
   max fd element even when fd are removed from the set */

#ifndef FDSET_H_
#define FDSET_H_

#include <sys/types.h>
#include <set>

namespace spades
{

  class FDSet
  {
  public:
    FDSet() : stl_set(), max(-1) { FD_ZERO(&basic_set); }
    ~FDSet() {}

    void add(int fd);
    void remove(int fd);
    void clear();

    fd_set getSet() const { return basic_set; }
    //this version update pmax if our max is larger
    fd_set getSet(int* pmax) const { if (max > *pmax) *pmax = max; return basic_set; }
    //returns -1 if the set is empty
    int getMax() const { return max; }

    bool empty() const { return stl_set.empty(); }
    unsigned size() const { return stl_set.size(); }
    
    typedef std::set<int, std::less<int> > STLSet;
    STLSet::const_iterator getSTLBegin() const { return stl_set.begin(); }
    STLSet::const_iterator getSTLEnd() const { return stl_set.end(); }

  private:

    fd_set basic_set;
    STLSet stl_set;
    int max;
  
  };

} //spades namespace


#endif
