/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This class provides my interface to the PerfCtr facilities */
/* It should only be compiled if PerfCtr support is enabled */
/* This extends PerfCtrFD */

#ifndef EXTPERFCTRFD_H_
#define EXTPERFCTRFD_H_

#include "PerfCtrFD.hpp"


namespace spades
{

  // This class encapsulates a file descriptor into a perfctr read area
  class ExtPerfCtrFD
    : public PerfCtrFD
  {
  public:
    ExtPerfCtrFD(int fd = -1, int pid = -1);
    ~ExtPerfCtrFD();

    // close this descriptor
    virtual bool close();

    // all calls to readSumPMC must go inbetween these calls
    bool initializeForRead();
    bool finalizeForRead();
    
    // reads the sum performance montoring counters
    // notably, this can be reading from a remote process
    // if we got the file decriptor off a unix domain socket
    // You must have previously called initializeForRead
    bool readSumPMC(int pmc_idx, unsigned long long* pres);

  private:
    ExtPerfCtrFD(const ExtPerfCtrFD&); // not acutally defined; should never be used
    const ExtPerfCtrFD& operator=(const ExtPerfCtrFD&); // not acutally defined; should never be used

    // checks the process status.
    // If it is not running, sig SUSPEND is sent to the proceess
    // return false or error
    // psent_suspend indicates whether suspect was sent
    bool ensureProcessNotRunning(bool* psent_suspend);
    
    int pid; // the pid this is for
    
    bool am_mmap;
    volatile const struct vperfctr_state *pkstate;
    bool on_multiproc;

    static const int MAX_SUSPEND_RETRIES = 10;
  };
  
  

} //spades namespace


#endif
