/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file defines the base event type, from which all events in the system
   must inherit */

#ifndef EVENT_H_
#define EVENT_H_

#include <iostream>
#include "sharedtypes.hpp"

namespace spades
{

  class WorldModel;
  class SimEngine;
  
  class Event
  {
  public:
    Event (SimTime t = -1, EventOrder o = EO_NORMAL)
      : time(t), order(o)
    { }
    virtual ~ Event () {}

    SimTime getTime () const { return time; }
    void setTime (SimTime t) { time = t; }

    EventOrder getOrder () const { return order; }
    //this is used if getOrder returns the same thing
    virtual int getSecondaryOrder() const = 0;
    
    virtual void print (std::ostream & o) const = 0;
    friend std::ostream & operator << (std::ostream & o, const Event & e)
    { e.print (o); return o; }

    //this function actually realizes the event. In general, you should not override this,
    // but override one of the protected methods realizeEventSimEngine or realizeEventWorldModel
    // returns true if the pointer was requeued anywhere (otherwise, it could be deleted)
    virtual bool realizeEvent(SimEngine* pSE);

    // Returns whether this event is a FixedAgentEvent; only FixedAgentEvent should redefine this
    virtual bool isFixedAgentEvent() { return false; }
    
  protected:
    //returns whether anything was done with this event
    virtual bool realizeEventSimEngine(SimEngine* pSE) { return false; }

    //should be redefined for whatever the world model wants to do
    // returns whether the world model did anything with this event
    virtual bool realizeEventWorldModel(WorldModel* pWM) { return false; }
    
  private:
    SimTime time;
    EventOrder order;
  };


} //spades namespace


#endif
