/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* this little class helps with the logging */

#ifndef ENGINETAGFUNCTION_H_
#define ENGINETAGFUNCTION_H_

#include <string>
#include "Logger.hpp"
#include "SimEngine.hpp"
#include "utility.hpp"

namespace spades
{

  class EngineTagFunction:public TagFunction
  {
  public:
    EngineTagFunction (const SimEngine * p = NULL)
      : pSE(p)
    {
    }
    std::string getTag (int level) const {return "TAGERROR";} //should never be called
    std::string getTag (int level, const std::string& channel_name) const
    { std::string s;
    s.insert (s.end (), level / 10, '-');
    return (pSE ? toString(pSE->getSimulationTime()) : "I") + "[" + channel_name + "]" + s;
    }
    std::string getErrorTag (int level) const
    {
      return (level == 0 ? "EngineError" : ("EngineWarning[" + toString(level) + "]"))
	+ (pSE ? ("("+toString(pSE->getSimulationTime())+")") : "") +": ";
    }

    void setSimEngine(SimEngine* p) 
    {
      pSE = p;
    }
  
  private:
    const SimEngine *pSE;
  };

} //spades namespace

#endif
