/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef ENGINEPARAM_H_
#define ENGINEPARAM_H_

#include "SharedParam.hpp"

namespace spades
{


  class EngineParam : public SharedParam
  {
  public:

    EngineParam ();
    virtual ~EngineParam ();

    static EngineParam* instance() { return s_instance; }

  private:
    static EngineParam* s_instance;
    
  protected:
    //virtual void writeConfig ( ostream& o );

    virtual void addAll2Maps ();
    virtual void setDefaultValues ();
    virtual void postReadProcessing() { SharedParam::postReadProcessing(); }

  public:

    int getPortBindRetries() const { return port_bind_retries; }
    int getPortBindSleepSec() const { return port_bind_sleep_sec; }
    
    bool getUseMonitorLog() const { return use_monitor_log; }
    std::string getMonitorLogFn() const { return monitor_log_fn; }
    int getMonitorInterval() const { return monitor_interval; }
    int getMonitorPort() const { return monitor_port; }
    bool getAcceptMonitorConnections() const { return accept_monitor_connections; }
    
    std::string getTextEventLogFn() const { return text_event_log_fn; }
    bool getUseTextEventLog() const { return use_text_event_log; }
    
    int getPauseModeWaitSec() const { return pause_mode_wait_sec; }
    int getPauseModeWaitUsec() const { return pause_mode_wait_usec; }
    int getWaitSec() const { return wait_sec; }
    int getWaitUsec() const { return wait_usec; }

    double getMaxPauseModeSeconds() const { return max_pause_mode_seconds; }

    double getTimeoutForEvent() const { return timeout_for_event; }

    double getTimeoutForCommserverFullConnect() const { return timeout_for_commserver_full_connect; }

    bool getUseMigration() const { return use_migration; }
    int getMinResponsesBeforeMigration() const { return min_responses_before_migration; }

    int getMaxAgentQTrailingTime() const { return max_agentq_trailing_time; }
    int getMaxTimenotTrailingTime() const { return max_timenot_trailing_time; }

    bool getRunIntegratedCommserver() const { return run_integrated_commserver; }

    double getLimitedRateDefaultSTPerSec() const { return limited_rate_default_st_per_sec; }
    double getLimitedRateRebaseInterval() const { return limited_rate_rebase_interval; }

  protected:

    int port_bind_retries;
    int port_bind_sleep_sec;
    
    bool use_monitor_log;
    std::string monitor_log_fn;
    int monitor_interval;
    int monitor_port;
    bool accept_monitor_connections;
    
    std::string text_event_log_fn;
    bool use_text_event_log;
    
    int pause_mode_wait_sec;
    int pause_mode_wait_usec;
    int wait_sec;
    int wait_usec;

    double max_pause_mode_seconds;
    
    double timeout_for_event;

    double timeout_for_commserver_full_connect;
    
    bool use_migration;
    int min_responses_before_migration;

    int max_agentq_trailing_time;
    int max_timenot_trailing_time;

    bool run_integrated_commserver;

    double limited_rate_default_st_per_sec;
    double limited_rate_rebase_interval;
  };

} //spades namespace

#endif
