/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef ENGINE_LOGGER_CHANNELS_H_
#define ENGINE_LOGGER_CHANNELS_H_

#include "Logger.hpp"

namespace spades
{

#define ELC spades::EngineLoggerChannels::instance()
  
  class EngineLoggerChannels
  {
  public:
    //This is a Singleton, you should only construct via instance()
    ~EngineLoggerChannels ();

    // a parent for all these other classed
    Logger::ChannelID engine() const { return cid_engine;}

    Logger::ChannelID agentalloc() const { return cid_agentalloc;}
    Logger::ChannelID comm() const { return cid_comm;}
    Logger::ChannelID integcs() const { return cid_integcs;}
    Logger::ChannelID monitor() const { return cid_monitor;}
    Logger::ChannelID eventman() const { return cid_eventman;}
    Logger::ChannelID events() const { return cid_events;}
    Logger::ChannelID agentcontrol() const { return cid_agentcontrol;}

  private:
    // a parent for all these other classed
    Logger::ChannelID cid_engine;

    Logger::ChannelID cid_agentalloc;
    Logger::ChannelID cid_comm;
    Logger::ChannelID cid_integcs;
    Logger::ChannelID cid_monitor;
    Logger::ChannelID cid_eventman;
    Logger::ChannelID cid_events;
    Logger::ChannelID cid_agentcontrol;
    
  public:
    static EngineLoggerChannels* instance();
  
  private:
    /* this is private so that the instance method is the only one that can allocate */
    EngineLoggerChannels ();
  
    static EngineLoggerChannels* s_instance;

  };

}

#endif
