/* -*- Mode: c++ -*- */

/*
 *Copyright:

    Copyright (C) 2002, 2003 Patrick Riley
    Copyright (C) 2001 Patrick Riley and Emil Talpes

    This file is part of the SPADES simulation system.

    The SPADES simulation system is free software; you can
    redistribute it and/or modify it under the terms of the GNU Lesser
    General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option)
    any later version.

    The SPADES simulation system is distributed in the hope that it
    will be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with the SPADES simulation system; if not, write to
    the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
    Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* this class implements a reference counted data array class
   the length of the data is maintained as well */

#ifndef DATA_ARRAY_H_
#define DATA_ARRAY_H_

#include <assert.h>
#include <string.h>
#include <sstream>
namespace std
{
  class ostrstream;
}
//#include <strstream>
#include <string>
#include <iostream>
#include "Writable.hpp"

//#define DEBUG_DATA_ARRAY 1

namespace spades {
  class DataArray
  {
  public:
    DataArray() {}
    DataArray(const DataArray& da) : strBuffer(da.strBuffer) {}
    DataArray(const char* buffer) : strBuffer(buffer) {}
    DataArray(const char* buffer, unsigned length) : strBuffer(buffer,length) {}
    // I have to have all three here to force the correct conversion
    DataArray(std::stringstream& str) : strBuffer(str.str()) {}
    DataArray(std::ostringstream& str) : strBuffer(str.str()) {}
    DataArray(std::istringstream& str) : strBuffer(str.str()) {}
    DataArray(std::streambuf& strbuf);
    DataArray(std::ostrstream& ostr);
    DataArray(const std::string& str);
    ~DataArray() {}

    const DataArray& operator=(const DataArray& da);

    // the data in the array is copied;
    void copyData(const char* data, unsigned length);

    const char* getData() const { return strBuffer.c_str(); }
    unsigned getSize() const { return strBuffer.size(); }

    std::string toString() const { return strBuffer; }

    //writes only the data, no size information
    int writeData(std::ostream& out) const;

    //returns the position in the buffer immediately after the last byte written
    //  NULL on error
    //does everything in network byte order
    char* writeToBuffer(char* buffer, unsigned max_len) const;
    //returns number of bytes written; note that it prefixes with the size
    int writeTo(Writable* out) const;
    //returns the position in the buffer immediately after the last byte written
    char* readFromBuffer(char* buffer, unsigned max_len);
    //returns the number of bytes needed in a data buffer
    unsigned bytesNeededInBuffer() const { return sizeof(short) + strBuffer.size(); }
    static bool isEnoughInBuffer(char* buffer, unsigned max_len);

    // This is only provided for -string!
    const std::string& getInternalString() const { return strBuffer; }
    
  private:
    std::string strBuffer;

  };

} //namespace spades

#endif
