/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file defines the base create sense type.
   WorldMoodels should inherit events from this class to generate sense events */


#ifndef CREATESENSEEVENT_H_
#define CREATESENSEEVENT_H_

#include "BaseCreateSenseEvent.hpp"
#include "SimEngine.hpp"

namespace spades
{

  class WorldModel;
  class SenseEvent;
  
  class CreateSenseEvent
    : public BaseCreateSenseEvent
  {
  public:
    CreateSenseEvent (SimTime t, AgentID a, EventOrder o = EO_CREATESENSE)
      : BaseCreateSenseEvent (t, o), agent(a)
    {}
    virtual ~CreateSenseEvent () { }

    int getSecondaryOrder() const { return static_cast<int>(agent); }

    virtual void print (std::ostream & o) const
    { o << "CreateSenseEvent(" << getTime () << ") for " << agent; }

    bool realizeEventSimEngine(SimEngine* pSE);

    //createSense is virtual from BaseCreateSenseEvent
    
    AgentID getAgent () const { return agent; }
    void setAgent (AgentID a) { agent = a; }

    
  private:
    AgentID agent;
  };

} //spades namespace



#endif
