/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* This file defines the base create sense type.
   WorldMoodels should inherit events from this class to generate sense events */

#ifndef CREATEMULTISENSEEVENT_H_
#define CREATEMULTISENSEEVENT_H_

#include <set>
#include "BaseCreateSenseEvent.hpp"

namespace spades
{
  class WorldModel;
  class SimEngine;
  class SenseEvent;
  
  class CreateMultiSenseEvent
    : public BaseCreateSenseEvent
  {
  public:
    CreateMultiSenseEvent (SimTime t, EventOrder o = EO_CREATESENSE)
      : BaseCreateSenseEvent (t, o), agents()
    {}
    virtual ~CreateMultiSenseEvent () { }

    // This returns the sum of all the agent numbers. In general, this is
    // going to have a number of aliases (like 2+3 = 4+1)
    // If you have a better general scheme, please implement it
    virtual int getSecondaryOrder() const;

    virtual void print (std::ostream & o) const;

    bool realizeEventSimEngine(SimEngine* pSE);

    void addAgent(AgentID a) { agents.insert(a); }
    bool isAgentMember(AgentID a) { return agents.count(a) > 0; }
    void removeAgent(AgentID a) { agents.erase(a); }

    // Iterator must be dereferencable to an AgentID, support ++, and be copy constructible
    template <class Iterator>
    void addAgents(Iterator begin, const Iterator& end)
    {
      while (begin != end)
	{
	  addAgent(*begin);
	  begin++;
	}
    }

    // Key is the key of a map whose value is an AgentID
    template <class Key>
    void addAgentsFromMapValues(typename std::map<Key, AgentID>::iterator begin,
				const typename std::map<Key, AgentID>::iterator& end)
    {
      while (begin != end)
	{
	  addAgent(begin->second);
	  begin++;
	}
    }
    
    template <class Value>
    void addAgentsFromMapKeys(typename std::map<AgentID, Value>::iterator begin,
			      const typename std::map<AgentID, Value>::iterator& end)
    {
      while (begin != end)
	{
	  addAgent(begin->first);
	  begin++;
	}
    }
    
  protected:
    typedef std::set<AgentID> SetAgents;
    SetAgents agents;
    
  };

} //spades namespace



#endif
