/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

/* this little class helps with the logging */

#ifndef CSTAGFUNCTION_H_
#define CSTAGFUNCTION_H_

#include <string>
#include "Logger.hpp"

namespace spades
{

  class CSTagFunction:public TagFunction
  {
  public:
    CSTagFunction ()
    {
    }
    std::string getTag (int level) const {return "TAGERROR";} //should never be called
    std::string getTag (int level, const std::string& channel_name) const
    { std::string s;
    s.insert (s.end (), level / 10, '-');
    return "[" + channel_name + "]" + s;
    }
    std::string getErrorTag (int level) const
    {
      return (level == 0 ? "CommServerError: " : ("CommServerWarning[" + toString(level) + "]: "));
    }
  private:

  };

} //spades namespace

#endif
