/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef AGENTLIBRARYPARAM_H_
#define AGENTLIBRARYPARAM_H_

#include "ParamReader.hpp"
#include "AgentTypeDB.hpp"

namespace spadesalib
{

  class AgentLibraryParam
    : public spades::ParamReader
  {
  public:

    AgentLibraryParam ();
    virtual ~ AgentLibraryParam ();

    static const AgentLibraryParam* instance() { return s_instance; }

  private:
    static AgentLibraryParam* s_instance;
    
  protected:
    //virtual void writeConfig ( ostream& o ) = 0;

    virtual void addAll2Maps ();
    virtual void setDefaultValues ();
    virtual void postReadProcessing ();

  public:

    std::string getLogfileDir () const { return logfile_dir; }
    std::string getActionLogFN () const { return action_log_fn; }
    int getActionLogLevel () const { return action_log_level; }
    std::vector<std::string> getLogChannels() const { return log_channels; }

    int  getRandomSeed() const { return random_seed; }

    int getWaitSec() const { return wait_sec; }
    int getWaitUsec() const { return wait_usec; }

    int getNumSelectsTimeout() const { return num_selects_timeout; }

    int getInputFD() const { return input_fd; }
    int getOutputFD() const { return output_fd; }
    
  protected:

    std::string logfile_dir;
    std::string action_log_fn;
    int action_log_level;
    std::vector<std::string> log_channels;

    int  random_seed;

    int wait_sec;
    int wait_usec;

    int num_selects_timeout;

    int input_fd;
    int output_fd;

  };

} //spadesalib namespace

#endif
