/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef AGENT_INTERFACE_INTEGRATED_H_
#define AGENT_INTERFACE_INTEGRATED_H_

#include <list>
#include <set>
#include <fstream>
#include <ltdl.h>
#include "AgentInterface.hpp"
#include "IntegratedAgent.hpp"

namespace spades
{
  class AgentInterfaceIntegrated
    : public AgentInterface
  {

  public:
    AgentInterfaceIntegrated(AgentManager* pmanager,
			     IntegratedAgent* pagent,
			     lt_dlhandle dlhandle,
			     AgentID id,
			     const AgentTypeIntegrated* pat, 
			     SimTime t);
    ~AgentInterfaceIntegrated();

    bool wasInitError() const { return init_error; }
    
    void addReadToFDSet(FDSet* pfdset) const { }
    void removeReadFromFDSet(FDSet* pfdset) const { }
    bool isReadInFDSet(const fd_set* pfdset) const { return false; }

    //returns whether there are messages in the queue now
    // note that we don't have to do any real processing here
    // The integrated agent should have already queued up everything
    // when it got "sent" it's messages (really a function call)
    bool readFromAgent() { return !isEngineOutQueueEmpty(); }

    // No process watching is required!
    void handOffProcessWatching(MessageServer* pmserver,
				ProcessKillList* ppkl,
				const TimeVal& tv_curr)
    { }

    std::string getProcessStatus() { return "integ"; }

    // returns false iff shutdown status is not none
    // need to check the out queue after this
    // We don't need to check up on an integrated agent
    bool checkupOnAgent(bool only_thinking) { return true; }
    
  protected:
    bool sendMessageTo(ToAgentMessage_TimeNotify* m);
    bool sendMessageTo(ToAgentMessage_Sense* m);
    bool sendMessageTo(ToAgentMessage_MigrationRequest* m);
    bool sendMessageTo(ToAgentMessage_Exit* m);
    bool sendMessageTo(ToAgentMessage_InitData* m);
    bool sendMessageTo(ToAgentMessage_Error* m);
    bool sendMessageTo(ToAgentMessage_ThinkTime* m);
    
  private:
    class ActionCallbacks
      : public IntegratedAgentActions
    {
    public:
      ActionCallbacks(AgentInterfaceIntegrated* p)
	: IntegratedAgentActions(), pinterface(p) {}
      ~ActionCallbacks() {}

      void act(const std::string& d);
      void requestTimeNotify(SimTime t);
      void doneThinking();
      void exit();
      void initDone();
      void migrationData(const std::string& d);
      void requestCurrentThinkTime();

    private:
      AgentInterfaceIntegrated* pinterface;
    };


    IntegratedAgent* pagent;
    lt_dlhandle dlhandle;
    bool init_error;
    ActionCallbacks* pcallbacks;
  };

  
  
  
} //spades namespace

#endif
