/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef AGENT_INTERFACE_EXTERNAL_H_
#define AGENT_INTERFACE_EXTERNAL_H_

#include <list>
#include <set>
#include <fstream>
#include "AgentInterface.hpp"
#include "WriteBuffCollFD.hpp"
#include "LengthPrefixedWriter.hpp"
#include "ReadBuffFD.hpp"
#include "ProcessTimer.hpp"

namespace spades
{
  // Class AgentInterface - keeps communication with an agent and queues all the requests for it
  // Note: you have to be careful with the ProcessTimer here. It registers itself
  // as a watcher for pids. You need to tell it to unregister before destroying
  // this object, otherwise the MessageServer could have a stale ForkWatcher pointer
  
  class AgentInterfaceExternal
    : public AgentInterface
  {

  public:
    AgentInterfaceExternal(AgentManager* pmanager,
			   int pid, const Message::MsgUniqueID& forkuniqid,
			   AgentID id,
			   const AgentTypeExternal* pat, 
			   int input, int output, SimTime t);
    ~AgentInterfaceExternal();

    void addReadToFDSet(FDSet* pfdset) const { pfdset->add(rb_client_out.getFD()); }
    void removeReadFromFDSet(FDSet* pfdset) const { pfdset->remove(rb_client_out.getFD()); }
    bool isReadInFDSet(const fd_set* pfdset) const { return FD_ISSET (rb_client_out.getFD(), pfdset); }

    //returns whether there are messages in the queue now
    bool readFromAgent();

    // Gives up the responsibility for watching over processes to the MessageServer and to
    // the ProcessKillList
    void handOffProcessWatching(MessageServer* pmserver,
				ProcessKillList* ppkl,
				const TimeVal& tv_curr);

    std::string getProcessStatus() { return getProcessTimer()->getProcessStatus(); }

    // returns false iff shutdown status is not none
    // need to check the out queue after this
    bool checkupOnAgent(bool only_thinking);
    
  protected:
    bool sendMessageTo(ToAgentMessage_TimeNotify* m);
    bool sendMessageTo(ToAgentMessage_Sense* m);
    bool sendMessageTo(ToAgentMessage_MigrationRequest* m);
    bool sendMessageTo(ToAgentMessage_Exit* m);
    bool sendMessageTo(ToAgentMessage_InitData* m);
    bool sendMessageTo(ToAgentMessage_Error* m);
    bool sendMessageTo(ToAgentMessage_ThinkTime* m);
    
  private:
    bool shouldCheckDeeply(double wall_clock_think_time);
    
    static const unsigned DEFAULT_RECVBUF_SIZE;

    // the two pipes we share with the client
    ReadBuffFD  rb_client_out;
    WriteBuffCollectorFD wb_client_in;
    LengthPrefixedWriter lp_writer;
    
    unsigned recvbuf_size;
    char* recvbuf;
    
  };

} //spades namespace

#endif
