/* -*- Mode: c++ -*- */

/*
 *Copyright:

 Copyright (C) 2002, 2003 Patrick Riley
 Copyright (C) 2001 Patrick Riley and Emil Talpes

 This file is part of the SPADES simulation system.

 The SPADES simulation system is free software; you can
 redistribute it and/or modify it under the terms of the GNU Lesser
 General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option)
 any later version.

 The SPADES simulation system is distributed in the hope that it
 will be useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with the SPADES simulation system; if not, write to
 the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 Boston, MA 02111-1307 USA

 *EndCopyright:
*/

#ifndef AGENT_COMM_INTERFACE_H_
#define AGENT_COMM_INTERFACE_H_

#include "ReadBuffFD.hpp"
#include "sharedtypes.hpp"
#include "LengthPrefixedWriter.hpp"
#include "ToCSMessage.hpp"
#include "FromCSMessage.hpp"
#include "ALibLoggerChannels.hpp"

namespace spadesalib
{
  
  class AgentCommInterface 
  {
  public:
    AgentCommInterface();
    ~AgentCommInterface();

    // Never blocks
    // Returns NULL if no message currently available
    FromCSMessage* tryMessageRead();
  
    //if this returns NULL, then there is an error and the agent should exit
    // the user of this class is responsible for this memory now
    FromCSMessage* receiveMessage();

    bool shouldShutdown() const { return shutdown; }
    void initiateShutdown() { shutdown = true; }

    //returns the latest time stamp received 
    spades::SimTime getLatestTime() const { return latest_time; }
  
    // send takes over the memory here
    bool send(ToCSMessage* m);

    int getOutstandingThinks() const { return outstanding_thinks; }
  
  private:
    static const int DEFAULT_BUFFER_SIZE;

    spades::ThinkingType senseCharToThinking(char c);
    spades::ThinkingType timeNotifyCharToThinking(char c);
  
    //parses the contents of recvbuf
    //length is the number of valid bytes
    //return NULL on error
    FromCSMessage* parseBuf(int length);

    void updateLatestTime(int t) { if (t>latest_time) latest_time = t; }
  
    spades::ReadBuffFD rbfd_from_commserv;
    spades::LengthPrefixedWriter lp_writer;

    char* recvbuf;
    unsigned recvbuf_size;
  
    bool shutdown;

    spades::SimTime latest_time;

    int outstanding_thinks;
  
  
  };
  
} //spadesalib namespace


#endif
