/* -*- mode: c++; c-basic-offset: 4; indent-tabs-mode: nil -*-

   this file is part of rcssserver3D
   Fri May 9 2003
   Copyright (C) 2002,2003 Koblenz University
   Copyright (C) 2003 RoboCup Soccer Server 3D Maintenance Group
   $Id: beamaction.h,v 1.2 2004/02/12 14:07:25 fruit Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef BEAMACTION_H
#define BEAMACTION_H

#include <oxygen/gamecontrolserver/actionobject.h>
#include <salt/vector.h>

class BeamAction : public oxygen::ActionObject
{
public:
    BeamAction(const std::string& predicate, salt::Vector3f pos)
        : ActionObject(predicate), mPos(pos) {}
    virtual ~BeamAction() {}

    /** returns the stored positin */
    const salt::Vector3f& GetPosition() { return mPos; }

protected:
    /** the position to beam the agent to */
    salt::Vector3f mPos;
};

#endif // BEAMACTION_H
