/* -*- mode: c++; c-basic-offset: 4; indent-tabs-mode: nil -*-

   this file is part of rcssserver3D
   Fri May 9 2003
   Copyright (C) 2002,2003 Koblenz University
   Copyright (C) 2003 RoboCup Soccer Server 3D Maintenance Group
   $Id: salt.h,v 1.11 2004/03/28 09:46:41 fruit Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* this file combines all includes files of the salt library in
 *  one file
 */
#ifndef SALT_SALT_H
#define SALT_SALT_H

#include "bounds.h"
#include "fileclasses.h"
#include "matrix.h"
#include "random.h"
#include "sharedlibrary.h"
#include "vector.h"
#include "plane.h"
#include "frustum.h"

/*! \mainpage rcssserver3D Documentation
 *
 * \section welcome Welcome!
 *
 * Below are some links to pages containing useful information regarding
 * the actual implementation of rcssserver3D.
 *
 * - <b><a href="developers/implementation.html">Implementation</a></b> This
 *   section gives an overview of how the source code distribution
 *   is structured. You should read it first.
 *
 * - <b><a href="developers/howtos.html">HowTos</a></b> This is probably
 *   the most useful section as it describes how to go about using the
 *   framework developed to realize custom simulations. For example, how do you
 *   implement a class which can live in the object hierarchy (and make it
 *   loadable from the Ruby script side).
 *
 * - <b><a href="http://lists.sourceforge.net/lists/listinfo/sserver-three-d">rcssserver3d list</a></b> The mailing list on sourceforge.net.
 *
 * - <b><a href="http://www.uni-koblenz.de/~fruit/publications/KO03a.html">Simulation League: The Next Generation</a></b> The extended version of the paper
 *   presented at the RoboCup Symposium 2003 in Padova.
 *
 * - <b><a href="http://www.uni-koblenz.de/~fruit/ftp/teaching/koe03-diplomarbeit.pdf">Thesis PDF</a></b> Diploma thesis of Marco Kgler (in PDF format)
 *   describing the concepts of a framework for simulating and visualizing
 *   agents in 3D environments. This framework was used as base for the current simulator.
 */

#endif //SALT_SALT_H
