/* -*- mode: c++; c-basic-offset: 4; indent-tabs-mode: nil -*-

   this file is part of rcssserver3D
   Fri May 9 2003
   Copyright (C) 2002,2003 Koblenz University
   Copyright (C) 2003 RoboCup Soccer Server 3D Maintenance Group
   $Id: monitorcmdparser.h,v 1.1 2004/12/31 14:07:00 rollmark Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef OXYGEN_MONITORCMDPARSER_H
#define OXYGEN_MONITORCMDPARSER_H

#include <zeitgeist/leaf.h>
#include <oxygen/gamecontrolserver/predicate.h>

namespace oxygen
{

class MonitorCmdParser : public zeitgeist::Leaf
{
public:
    MonitorCmdParser();
    virtual ~MonitorCmdParser();

    /** This function is called from the monitor server implementation
        to parse any command strings received from the monitor client
        process
     */
    virtual void ParseMonitorMessage(const std::string& data) = 0;
};

} // namespace oxygen

DECLARE_ABSTRACTCLASS(MonitorCmdParser);

#endif // OXYGEN_MONITORCMDPARSER_H
