// -*-c++-*-

/***************************************************************************
                                resultsaver.hpp
                    Abstract Base Class for saving results
                             -------------------
    begin                : 08-MAY-2003
    copyright            : (C) 2003 by The RoboCup Soccer Simulator 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/


#ifndef RCSSRESULTSAVER_HPP
#define RCSSRESULTSAVER_HPP


#include <string>
#include <rcssbase/lib/factory.hpp>
#include <rcssbase/lib/shared_ptr.hpp>

struct tm;



namespace rcss
{
    class ResultSaver
    {
    public:
        typedef lib::shared_ptr< ResultSaver > Ptr;
        typedef Ptr(*Creator)();    
        typedef lib::Factory< Creator > Factory;

        static
        Factory&
        factory();

        enum team_id { TEAM_LEFT = 0, TEAM_RIGHT = 1 };

        ResultSaver()
        {}

        virtual
        ~ResultSaver()
        {}

        bool
        enabled() const
        { return doEnabled(); }

        void
        saveStart()
        { doSaveStart(); }

        void
        saveTime( const tm& time )
        { doSaveTime( time ); }

        void
        saveTeamName( team_id team, const std::string& name )
        { doSaveTeamName( team, name ); }

        void
        saveCoachName( team_id team, const std::string& name )
        { doSaveCoachName( team, name ); }

        void
        saveScore( team_id team, unsigned int score )
        { doSaveScore( team, score ); }

        void
        savePenTaken( team_id team, unsigned int taken )
        { doSavePenTaken( team, taken ); }

        void
        savePenScored( team_id team, unsigned int scored )
        { doSavePenScored( team, scored ); }

        void
        saveCoinTossWinner( team_id team )
        { doSaveCoinTossWinner( team ); }

        bool
        saveComplete()
        { return doSaveComplete(); }

	const char*
	getName() const
	{ return doGetName(); }
    private:

        virtual
        bool
        doEnabled() const
        { return false; }

        virtual
        void
        doSaveStart()
        {}

        virtual
        void
        doSaveTime( const tm& )
        {}

        virtual
        void
        doSaveTeamName( team_id, const std::string& )
        {}

        virtual
        void
        doSaveCoachName( team_id, const std::string& )
        {}

        virtual
        void
        doSaveScore( team_id, unsigned int )
        {}

        virtual
        void
        doSavePenTaken( team_id, unsigned int )
        {}

        virtual
        void
        doSavePenScored( team_id, unsigned int )
        {}

        virtual
        void
        doSaveCoinTossWinner( team_id )
        {}

        virtual
        bool
        doSaveComplete()
        { return true; }
	
	virtual
	const char*
	doGetName() const = 0;

    };
}


#endif
