// -*-c++-*-

/***************************************************************************
                                  parser.h  
                               Parser template
                             -------------------
    begin                : 24-MAY-2002
    copyright            : (C) 2002 by The RoboCup Soccer Server 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#ifndef PARSER_H
#define PARSER_H

#include <string>
#include <iostream>
#include <fstream>

namespace rcss
{
  class Parser
  {
  private:
    std::string M_file_name;
    
  public:
    Parser()
      : M_file_name( "" )
    {}

    virtual
    ~Parser()
    {}

    bool
    parse( std::istream& strm )
    { 
      return doParse( strm );
    }

      bool
      parse( std::istream& strm, std::ostream& errstrm )
      {
          return doParse( strm, errstrm );
      }

    bool
    parse( std::istream& strm, const std::string& name )
    { 
        M_file_name = name;
        return doParse( strm );
    }

      bool
      parse( std::istream& strm, const std::string& name,
             std::ostream& errstrm )
      { 
          M_file_name = name;
          return doParse( strm, errstrm );
      }

      bool
      parse( const std::string& file )
      {
          return parse( file, std::cerr );
      }

    bool
    parse( const std::string& file, std::ostream& errstrm )
    {
      std::ifstream strm( file.c_str() );

      if( !strm.is_open() )
        return false;

      bool rval = parse( strm, file, errstrm );

      strm.close();

      return rval;
    }

  private:
    virtual
    bool
    doParse( std::istream& strm ) = 0;

      virtual
      bool
      doParse( std::istream& strm, std::ostream& )
      { return doParse( strm ); }

  protected:
    const std::string&
    getFileName() const
    { return M_file_name; }

    const std::string&
    getStreamName() const
    { return M_file_name; }
  };

  inline
  std::string
  stripQuotes( std::string str, char quote = '"' )
  {
    // returns a new string with the quotes removed or as is if there
    // are no bounding quotes
    if ( str.empty() )
      return str;
    else if( str[ 0 ] == quote )
      str = str.substr( 1, str.length() - 1 );
    
    if( str[ str.length() - 1 ] == quote )
      return str.substr( 0, str.length() - 1 );
   
    return str;
  }
}


#endif
