// -*-c++-*-

/***************************************************************************
                              preloader.hpp
                             -------------------
                        Used to preload libs
    begin                : 2003-Sep-01
    copyright            : (C) 2003 by The RoboCup Soccer Simulator 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/


#ifndef RCSS_LIB_PRELOADER_HPP
#define RCSS_LIB_PRELOADER_HPP

#if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(CYGWIN)
#ifdef RCSSLIB_EXPORTS
#define RCSSLIB_API __declspec(dllexport)
#define RCSSLIB_EXTERN
#else
#define RCSSLIB_API __declspec(dllimport)
#define RCSSLIB_EXTERN extern
#endif
#elif defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
#define RCSSLIB_API
#define RCSSLIB_EXTERN extern
#else
#define RCSSLIB_API
#define RCSSLIB_EXTERN
#endif

#include <vector>

namespace rcss
{
    namespace lib
    {
		class RCSSLIB_API Preloader;
	}
}

RCSSLIB_EXTERN template class RCSSLIB_API std::allocator< const rcss::lib::Preloader* >;
RCSSLIB_EXTERN template class RCSSLIB_API std::vector< const rcss::lib::Preloader* >;

namespace rcss
{
    namespace lib
    {
        class RCSSLIB_API Preloader
        {
        public:
            typedef bool(*Initialize)();
            typedef void(*Finalize)();

            Preloader( const char* name, Initialize fin, Finalize init );

            ~Preloader();
            
            const char*
            name() const;

            Initialize
            init() const;

            Finalize
            fin() const;

        private:
            typedef std::vector< const Preloader* > Holder;
            friend class PreloadLoader;

            static
            void
            addLib( const Preloader& pre );
            
            static
            void
            remLib( const Preloader& pre );

            static
            Holder&
            preloads();

            static Holder s_preloads;
 
            const char* m_name;
            Initialize m_init;
            Finalize m_fin;

       };
    }
}



#endif
