// -*-c++-*-

/***************************************************************************
                                loaderimpl.hpp
                             -------------------
                base class for implementing a dynamically library loader
    begin                : 2003-Sep-01
    copyright            : (C) 2003 by The RoboCup Soccer Simulator 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/


#ifndef RCSS_LIB_LOADERIMPL_HPP
#define RCSS_LIB_LOADERIMPL_HPP

#if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(CYGWIN)
#ifdef RCSSLIB_EXPORTS
#define RCSSLIB_API __declspec(dllexport)
#define RCSSLIB_EXTERN
#else
#define RCSSLIB_API __declspec(dllimport)
#define RCSSLIB_EXTERN extern
#endif
#elif defined(macintosh) || defined(__APPLE__) || defined(__APPLE_CC__)
#define RCSSLIB_API
#define RCSSLIB_EXTERN extern
#else
#define RCSSLIB_API
#define RCSSLIB_EXTERN
#endif

#include "factory.hpp"
#include <boost/shared_ptr.hpp>

class RCSSLIB_API boost::detail::shared_count;
RCSSLIB_EXTERN template class RCSSLIB_API boost::shared_ptr< char >;

namespace rcss
{
    namespace lib
    {
        class RCSSLIB_API LoaderImpl
        {
        public:
            enum AutoExt { NO_AUTO_EXT, AUTO_EXT };
            enum Error { LIB_OK, NOT_FOUND, INIT_ERROR, SYSTEM_ERROR };

            typedef boost::shared_ptr< LoaderImpl > Ptr;
            typedef Ptr(*Creator)( const boost::shared_ptr< char >&, AutoExt, const char* path );
            typedef Factory< Creator > Factory;
 
            static
            Factory&
            factory();

            virtual
            ~LoaderImpl();
            
            boost::shared_ptr< char >
            name() const
            { return m_name; }
            
            boost::shared_ptr< char >
            strippedName() const
            { return m_stripped_name; }
            
            Error
            error() const;
            
	    boost::shared_ptr< char >
	    errorStr() const
	    { return m_system_err_str; }

            bool
            valid() const;

         protected:
            typedef bool(*Initialize)();
            typedef void(*Finalize)();
            
	    LoaderImpl( const boost::shared_ptr< char >& lib, AutoExt auto_ext, const char* path );
            
            void
            load();
            
            void
            close();
            
            bool
            autoExt()
            {
                return m_auto_ext == AUTO_EXT;
            }

            void
            error( Error e );

	    void
            error( const char* err_str );

	    const char*
	    getPath() const
	    {
		return m_path;
	    }
        private:
            
            virtual
            void
            doLoad() = 0;
            
            virtual
            void
            doClose() = 0;
            
            virtual
            Initialize
            doGetInitialize() const = 0;     
            
            virtual
            Finalize
            doGetFinalize() const = 0;     
            
            void
            initialize();
            
            void
            finalize();
            
            friend class Loader;
        private:
            boost::shared_ptr< char > m_name;
            boost::shared_ptr< char > m_stripped_name;
            AutoExt m_auto_ext;
            Error m_error;
	    boost::shared_ptr< char > m_system_err_str;
	    const char* m_path;
        };

	/// Used to provide a static interface for the LoaderImpl subclasses
	class RCSSLIB_API LoaderStaticImpl
	{
	public:
	    typedef boost::shared_ptr< LoaderStaticImpl > Ptr;
            typedef Ptr(*Creator)();
            typedef Factory< Creator > Factory;
 
            static
            Factory&
            factory();

            virtual
            ~LoaderStaticImpl();

	    virtual
	    std::vector< boost::shared_ptr< char > >
	    listAvailableModules() = 0;
	protected:
	    LoaderStaticImpl();
	};
    }
}

#endif
