// -*-c++-*-

/***************************************************************************
                                 gzfstream.hpp
                      Compression and decompression file streams
                             -------------------
    begin                : 14-DEC-2003
    copyright            : (C) 2001, 2002, 2003 by The RoboCup Soccer Server 
                           Maintenance Group.
    email                : sserver-admin@lists.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU LGPL as published by the Free Software  *
 *   Foundation; either version 2 of the License, or (at your option) any  *
 *   later version.                                                        *
 *                                                                         *
 ***************************************************************************/

#ifndef GZFSTREAM_H
#define GZFSTREAM_H

#include <iostream>
#include <boost/shared_ptr.hpp>


namespace rcss
{
    namespace gz
    {
	class gzfstreambuf_impl;

	class gzfstreambuf
	    : public std::streambuf
	{
	public:
	    typedef int int_type;
	    typedef char char_type;

	    enum Compression { NO_COMPRESSION = 0, 
			       BEST_SPEED = 1,
			       BEST_COMPRESSION = 9,
			       DEFAULT_COMPRESSION = -1 };

	    enum Strategy { FILTERED,
			    HUFFMAN_ONLY,
			    DEFAULT_STRATEGY };

	
	    gzfstreambuf ( int bufsize = 512 );
	    ~gzfstreambuf ();

	    bool is_open ();

	    bool
	    open( const char* path, 
		  int level = DEFAULT_COMPRESSION,
		  int strategy = DEFAULT_STRATEGY );


	    bool open ( int fd,
			int level = DEFAULT_COMPRESSION,
			int strategy = DEFAULT_STRATEGY );

	    void close ();

	protected:
	    void _flush();
	    int_type overflow(int_type c);
//       int_type overflow();
	    int sync();
	    int_type underflow();
	
	private:

	    // not for use
	    gzfstreambuf(const gzfstreambuf&);
	
	    gzfstreambuf& operator=(const gzfstreambuf&);


	    bool M_open;
	    boost::shared_ptr< gzfstreambuf_impl > M_gzfile;
	    std::streamsize bufsize_;
	    char_type *inbuf_;
	    char_type *outbuf_;
	    int remained_;
	    char_type remainedchar_;
	};

	class gzfstream :
	    public gzfstreambuf,
	    public std::iostream
	{
	public:
	    
	    gzfstream( int buffer_size = 512 );
	    
	private:
	    // not for use
	    gzfstream(const gzfstream&);
	    gzfstream& operator=(const gzfstream&);
	};
    } // namespace gz
} // namespace rcss

#endif 
