#!/usr/bin/perl -w
# DO NOT EDIT
# This file was automatically generated from the .plin file, edit that
# This will converted to a .pl with the perl path added by my Makefile

# This script unpacks a think time file into a human readable format

$usage = "$0 <ttimefn> [<num per line> (default=1)]";

$fn = shift @ARGV;
$num_per_line = shift @ARGV;
(defined $fn) || die $usage;
$num_per_line = 1 if (!defined($num_per_line));

open (FH, "<$fn") || die "Could not open file '$fn': $!";

$ret = read(FH, $_, 4);
die "Could not read bytes per: $!" if (!defined($ret));
die "End of file before reading bytes per" if ($ret == 0);
die "Did not read correct number of bytes ($ret != 4)" if ($ret != 4);

$bytes_per = unpack("N", $_);

print "Bytes per time: $bytes_per\n";

if ($bytes_per == 2)
  {
    $format = "n";
  }
else
  {
    die "I can only handle 2 bytes per think time (file has $bytes_per). Want to fix me?";
  }

$cnt_on_line = 0;
for (;;)
  {
    $ret = read(FH, $_, $bytes_per);
    die "Error in read: $!" if (!defined($ret));
    last if ($ret == 0); #eof
    die "Did not read correct number of bytes ($ret != $bytes_per), partial write?" if ($ret != $bytes_per);

    $ttime = unpack($format, $_);
    print "$ttime ";
    ++$cnt_on_line;
    if ($cnt_on_line == $num_per_line)
      {
	$cnt_on_line = 0;
	print "\n";
      }
  }

print "\n" if ($cnt_on_line != 0);
