/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.browser;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.browser.NewsBrowserInput;

public class NewsBrowser
extends EditorPart
implements IReusableEditor {
    public static final String ID;
    Browser browser;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.browser.NewsBrowser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public void setInput(IEditorInput input) {
        NewsBrowserInput binput;
        super.setInput(input);
        if (this.browser != null && !StringUtils.isEmpty((String)(binput = (NewsBrowserInput)input).getUrl())) {
            this.browser.setUrl(binput.getUrl());
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof NewsBrowserInput)) {
            throw new PartInitException("Input must be instance of NewsBrowserInput");
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void createPartControl(Composite parent) {
        NewsBrowserInput input = (NewsBrowserInput)this.getEditorInput();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.browser = new Browser(composite, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                String str;
                IPreferenceStore store = NewsUIPlugin.getDefault().getPreferenceStore();
                int length = store.getInt("newsEditorMaxTabLength");
                length = length < (str = event.title).length() ? length : str.length();
                NewsBrowser.this.setPartName(str.substring(0, length));
            }
        });
        final IActionBars actionBars = this.getEditorSite().getActionBars();
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(actionBars){
            IProgressMonitor monitor;
            boolean working;
            int workedSoFar;
            {
                this.monitor = iActionBars.getStatusLineManager().getProgressMonitor();
                this.working = false;
            }

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                if (!this.working) {
                    if (event.current == event.total) {
                        return;
                    }
                    this.monitor.beginTask("", event.total);
                    this.workedSoFar = 0;
                    this.working = true;
                }
                this.monitor.worked(event.current - this.workedSoFar);
                this.workedSoFar = event.current;
            }

            public void completed(ProgressEvent event) {
                this.monitor.done();
                this.working = false;
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                try {
                    NewsBrowser browser = (NewsBrowser)NewsBrowser.this.getSite().getPage().openEditor((IEditorInput)new NewsBrowserInput(""), ID);
                    event.browser = browser.getBrowser();
                }
                catch (PartInitException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(actionBars){
            IStatusLineManager status;
            {
                this.status = iActionBars.getStatusLineManager();
            }

            public void changed(StatusTextEvent event) {
                this.status.setMessage(event.text);
            }
        });
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                actionBars.getStatusLineManager().getProgressMonitor().done();
            }
        });
        if (!StringUtils.isEmpty((String)input.getUrl())) {
            this.browser.setUrl(input.getUrl());
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }
}

