/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.model.rss20.clipper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import razgriz.common.text.XMLFirstElementPicker;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.rss20.Channel;
import razgriz.news.model.rss20.Item;
import razgriz.news.model.rss20.RSS;
import razgriz.news.model.rss20.util.DefaultRSS20ResourceFactoryImpl;

public class RSS20NewsClipper
implements NewsClipper {
    public boolean canClip(InputStream in) {
        XMLFirstElementPicker picker = new XMLFirstElementPicker();
        XMLFirstElementPicker.XMLElement elem = picker.pick(in);
        return "rss".equals(elem.getQName());
    }

    public News clip(InputStream in) {
        URI uri = URI.createURI((String)"razgriz://stream");
        try {
            Resource res = new DefaultRSS20ResourceFactoryImpl().createResource(uri);
            res.load(in, null);
            if (res.getContents().isEmpty()) {
                throw new IllegalArgumentException("Document root element not found");
            }
            RSS rss = (RSS)res.getContents().get(0);
            return this.convert(rss);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public News convert(RSS rss) {
        NewsFactory fact = NewsFactory.eINSTANCE;
        News ret = fact.createNews();
        List channels = rss.getChannel();
        int i = 0;
        int len = channels.size();
        while (i < len) {
            Channel ch = (Channel)rss.getChannel().get(i);
            if (i == 0) {
                ret.setDate(ch.getPubDate());
                ret.setDescription(ch.getDescription());
                ret.setLink(ch.getLink());
                ret.setTitle(ch.getTitle());
            }
            List items = ch.getItem();
            int j = 0;
            int jlen = items.size();
            while (j < jlen) {
                Item item = (Item)items.get(j);
                Article article = fact.createArticle();
                article.setAuthor(item.getAuthor());
                article.setDescription(item.getDescription());
                article.setLink(item.getLink());
                Date date = item.getPubDate();
                date = date == null ? new Date() : date;
                article.setDate(date);
                article.setTitle(item.getTitle());
                article.setRead(false);
                ret.getArticles().add(article);
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

